@echo off
setlocal enabledelayedexpansion

title Video compression and normalization via ffmpeg

REM Check for ffmpeg
where ffmpeg >nul 2>nul
if %errorlevel% neq 0 (
    echo [ERROR] ffmpeg not found!
    echo Please install ffmpeg and add to PATH
    echo Link: https://ffmpeg.org/download.html
    pause
    exit /b 1
)

REM Create Output folder
if not exist "Output" mkdir "Output"

REM Normalization filter (Standard mode)
set "filter=loudnorm=I=-16:TP=-1.5:LRA=11"

echo ==========================================
echo    VIDEO COMPRESSION AND NORMALIZATION
echo ==========================================
echo.
echo Mode: Standard normalization
echo Filter: %filter%
echo.
echo Output folder: Output
echo.

REM Count files
set count=0
for %%f in (*.mp4) do (
    if exist "%%f" set /a count+=1
)

if %count%==0 (
    echo No video files found in current folder!
    pause
    exit /b 1
)

echo Files found for processing: %count%
echo.
pause

REM File processing
set processed=0
set errors=0

for %%f in (*.mp4) do (
    if exist "%%f" (
        set /a processed+=1
        echo [!processed!/%count%] Processing: %%f

        REM Compress and normalize
        ffmpeg -i "%%f" -c:v libx264 -crf 30 -c:a aac -b:a 128k -af "%filter%" "Output\compressed_normalized_%%f" -y

        if !errorlevel! equ 0 (
            echo [SUCCESS] %%f processed
        ) else (
            echo [ERROR] Failed to process %%f
            set /a errors+=1
        )
        echo.
    )
)

REM Summary
echo ==========================================
echo           PROCESSING COMPLETE
echo ==========================================
echo Processed files: %processed%
echo Errors: %errors%
echo Results in folder: Output
echo.

if %errors% gtr 0 (
    echo Warning: Some files could not be processed
)

pause